# Geometry

This sub-menu provides access to Vertex, Edge, and Face edit mode tools.

![Tools > ProBuilder > Geometry menu](images/menu-geometry.png)

## Bevel Edges

Use the **Bevel** tool to [bevel](Edge_Bevel.md) every edge on the selected face(s).

For more information, see the [Bevel](Face_Bevel.md) tool documentation.

## Bridge Edges

Use the **Bridge Edges** tool to create a new face between two selected edges. 

For more information, see the [Bridge Edges](Edge_Bridge.md) tool documentation.

## Collapse Vertices

Use the **Collapse Vertices** tool to colapse all selected vertices to a single point, regardless of distance. 

For more information, see the [Collapse Vertices](Vert_Collapse.md) tool documentation.

## Conform Face Normals

Use the **Conform Normals** tool to set all selected face normals to the same relative direction. 

For more information, see the [Conform Normals](Face_ConformNormals.md) tool documentation.

## Delete Faces

Use the **Delete Faces** tool to delete the selected face(s).

For more information, see the [Delete Faces](Face_Delete.md) tool documentation.

## Detach Faces

Use the **Detach Faces** tool to detach the selected face(s) from the rest of the Mesh.

For more information, see the [Detach Faces](Face_Detach.md) tool documentation.

## Extrude

In Edge edit mode, use the **Extrude Edges** tool to push a new edge out from each selected edge.

In Face edit mode, use the **Extrude Faces** tool to pull out the currently selected face and attach sides to each edge.

For more information, see the documentation for the [Extrude Edges](Edge_Extrude.md) and the [Extrude Faces](Face_Extrude.md) tools.

## Fill Hole

In Vertex and Edge editing modes, use the **Fill Hole** tool to create a new face that fills any holes that touch the selected vertices or edges.

For more information, see the documentation for the [Fill Hole (vertices)](Vert_FillHole.md) and [Fill Hole (edges)](Edge_FillHole.md) tools.

## Flip Face Edge

Use the **Flip Face Edge** (**Turn Edges**) tool to swap the triangle orientation on the selected face(s) with four sides.

For more information, see the [Flip Face Edge](Face_FlipTri.md) tool documentation.

## Flip Face Normals

Use the **Flip Face Normals** tool to flip the normals only on the selected face(s).

For more information, see the [Flip Face Normals](Face_FlipNormals.md) tool documentation.

## Insert Edge Loop

Use the **Insert Edge Loop** tool to add a new edge loop from the selected edge(s). 

For more information, see the [Insert Edge Loop](Edge_InsertLoop.md) tool documentation.

## Merge Faces

Use the **Merge Faces** tool to merge selected faces into a single face, and remove any dividing edges.

For more information, see the [Merge Faces](Face_Merge.md) tool documentation.

## Set Pivot To Selection

Use the **Set Pivot** tool to move the pivot point of this Mesh to the average center of the selected faces.

For more information, see the [Set Pivot](Face_SetPivot.md) tool documentation.

## Smart Connect

In Vertex edit mode, use the **Connect Vertices** tool to create a new edge connecting the selected vertices.

In Edge edit mode, use the **Connect Edges** tool to insert an edge connecting the centers of each selected edge.

For more information, see the documentation for the [Connect Vertices](Vert_Connect.md) and [Connect Edges](Edge_Connect.md) tools.

## Smart Subdivide

In Edge edit mode, use the **Subdivide Edges** tool to divide the selected edge(s) into multiple edges. 

In Face edit mode, use the **Subdivide Faces** tool to add a vertex at the center of each edge and connect them in the center.

For more information, see the documentation for the [Subdivide Edges](Edge_Subdivide.md) and [Subdivide Faces](Face_Subdivide.md) tools.

## Split Vertices

Use the **Split Vertices** tool to split a single vertex into multiple vertices (one per adjacent face).

For more information, see the [Split Vertices](Vert_Split.md) tool documentation.

## Triangulate Faces

Use the **Triangulate Faces** tool to reduce selected faces to their base triangles.

For more information, see the [Triangulate Faces](Face_Triangulate.md) tool documentation.

## Weld Vertices

Use the **Weld Vertices** tool to merge selected vertices within a specific distance of one another.

For more information, see the [Weld Vertices](Vert_Weld.md) tool documentation.

