# Object Actions

This section of the ProBuilder toolbar provides access to ProBuilder editing tools that you can use in the [Object edit mode](modes.md).

![Tool Panels on the ProBuilder toolbar](images/tool_objects.png)

> **Note:** Some actions also have extra options or custom settings available. These tool buttons have a special indicator in the top right corner. The documentation for each tool includes information about these options.

## ![Triangulate icon](images/icons/Object_Triangulate.png) Triangulate

Use the **Triangulate** tool to reduce all polygons to their base triangles.

For more information, see the [Triangulate](Object_Triangulate.md) tool documentation.

## ![Conform Normals icon](images/icons/Object_ConformNormals.png) Conform Normals

Use the **Conform Normals** tool to set all face normals to the same relative direction.

For more information, see the [Conform Normals](Object_ConformNormals.md) tool documentation.

## ![Generate UV2 icon](images/icons/Object_LightmapUVs.png) Lightmap UVs

Use the **Lightmap UVs** tool to generate any missing lightmap UVs for Meshes.

For more information, see the [Lightmap UVs](Object_LightmapUVs.md) tool documentation.

## ![Export icon](images/icons/Object_Export.png) Export

Use the **Export** tool to [export](workflow-exporting.md#export) the selected ProBuilder object(s) to a 3D Model file. 

For more information, see the [Export](Object_Export.md) tool documentation.

## ![ProBuilderize icon](images/icons/Object_ProBuilderize.png) ProBuilderize

Use the **ProBuilderize** tool to convert the selected object(s) into objects you can edit in ProBuilder.

For more information, see the [ProBuilderize](Object_ProBuilderize.md) tool documentation.

## ![Center Pivot icon](images/icons/CenterPivot.png) Center Pivot

Use the **Center Pivot** tool to move the pivot point for the Mesh to the center of the object’s bounds.

For more information, see the [Center Pivot](CenterPivot.md) tool documentation.

## ![Mirror Objects icon](images/icons/Object_Mirror.png) Mirror Objects

Use the **Mirror Objects** tool to create mirrored copies of objects.

For more information, see the [Mirror Objects](Object_Mirror.md) tool documentation.

## ![Merge Objects icon](images/icons/Object_Merge.png) Merge Objects

Use the **Merge Objects** tool to merge two or more selected ProBuilder Meshes.

For more information, see the [Merge Objects](Object_Merge.md) tool documentation.

## ![Flip Normals icon](images/icons/Object_FlipNormals.png) Flip Normals

Use the **Flip Normals** tool to flip the normals of **all** faces on the selected object(s).

For more information, see the [Flip Normals](Object_FlipNormals.md) tool documentation.

## ![Freeze Transform icon](images/icons/Freeze_Transform.png) Freeze Transform

Use the **Freeze Transform** tool to set the selected object's position, rotation, and scale to world-relative origin.

For more information, see the [Freeze Transform](Freeze_Transform.md) tool documentation.

## ![Subdivide Object icon](images/icons/Object_Subdivide.png) Subdivide Object

Use the **Subdivide Object** tool to divide every face on selected objects.

For more information, see the [Subdivide Object](Object_Subdivide.md) tool documentation.
