 <?php /* * Template Name: Contact */  ?>
  
<?php get_header(); ?>

<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 25; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li>Company</li>
				<li class="active">
					<?php 
						$char_limit = 25; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->

<!--Page data-->
<section class="contact-content">
	<div class="container">                    
		<div class="row">                
			<div class="col-md-4 col-sm-6">
				<div class="sec-title style-two">
					<h2>Address</h2>
					<span class="decor"><span class="inner"></span></span>
				</div>
				<ul class="contact-info">
					<li>
						<div class="icon-box">
							<div class="inner">
								<i class="fa fa-map-marker"></i>
							</div>
						</div>
						<div class="content-box">
							<h4>Address</h4>
							<p><?php the_field('address'); ?></p>
						</div>
					</li>
					<li>
						<div class="icon-box">
							<div class="inner">
								<i class="fal fa-phone-office"></i>
							</div>
						</div>
						<div class="content-box">
							<h4>Toll Free</h4>
							<p>
								<?php if( get_field('toll_free') ): ?>
								<a href="tel:<?php the_field('toll_free'); ?>" style="color: green;"><?php the_field('toll_free'); ?></a>
								<?php endif; ?>
							</p>							
						</div>                            
					</li>
					<?php if( get_field('mobile1') ): ?>
					<li>
						<div class="icon-box">
							<div class="inner">
								<i class="fa fa-phone"></i>
							</div>
						</div>
						<div class="content-box">
							<h4>Phone</h4>
							<p>
								<?php if( get_field('mobile1') ): ?>
								+91 <a href="tel:<?php the_field('mobile1'); ?>" style="color: green;"><?php the_field('mobile1'); ?></a>
								<?php endif; ?>
								<?php if( get_field('mobile2') ): ?>
								+91 <a href="tel:<?php the_field('mobile2'); ?>" style="color: green;"><?php the_field('mobile2'); ?></a>
								<?php endif; ?>
							</p>
							<p>
								<?php if( get_field('mobile3') ): ?>
								+91 <a href="tel:<?php the_field('mobile3'); ?>" style="color: green;"><?php the_field('mobile3'); ?></a>
								<?php endif; ?>
							</p>
						</div>                            
					</li>
					<?php endif; ?>

					<li>
						<div class="icon-box">
							<div class="inner">
								<i class="fa fa-envelope"></i>
							</div>
						</div>
						<div class="content-box">
							<h4>Email</h4>
							<?php if( get_field('email1') ): ?>
							<p><a href="mailto:<?php the_field('email1'); ?>"><?php the_field('email1'); ?></a></p>
							<?php endif; ?>
							<?php if( get_field('email2') ): ?>
							<p><a href="mailto:<?php the_field('email2'); ?>"><?php the_field('email2'); ?></a></p>
							<?php endif; ?>
						</div>
					</li>

					<li>
						<div class="icon-box">
							<div class="inner">
								<i class="fa fa-globe"></i>
							</div>
						</div>
						<div class="content-box">
							<h4>Website</h4>
							<p><?php the_field('web'); ?></p>
						</div>
					</li>
				</ul>
			</div>
			<div class="col-md-4 col-sm-6">                
				<div class="sec-title style-two">
					<h2>Feedback</h2>
					<span class="decor"><span class="inner"></span></span>
				</div>
				<div class="model-forms">
				<?php echo do_shortcode( '[contact-form-7 id="242" title="Contact form 1"]' ); ?>
					
				</div>	
			</div>
			<div class="col-md-4 col-sm-6">                
				<div class="sec-title style-two">
					<h2>Location Map</h2>
					<span class="decor"><span class="inner"></span></span>
				</div>
				<div class="google-map">
					<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d14018.881527514575!2d77.2520596!3d28.5481232!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x5b43e09df51bd5fb!2sIfci%20Tower!5e0!3m2!1sen!2sin!4v1649325521469!5m2!1sen!2sin" style="border:0;width: 100%; height: 400px;"  allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></div>
				</div>	
			</div>
		</div>
	</div>
</section>
<!--Page data end-->

<?php get_footer(); ?>
 