<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since 1.0.0
 */

?>

<footer class="footer-area footer-layout1">
	<div class="footer-widget-area pt-20 pt-md-20 pt-lg-30">
		<div class="container">
			<div class="row">
				<div class="col-sm-6 col-lg-3">
					<div class="widget-about">
						<div class="logoofthefooter"><a href="<?php echo site_url(); ?>"><img src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/Foroly.png" title="Foroly India " alt="Foroly India "></a>	</div>						
					</div>
					<div class="widget">
						<div class="vs-contact-widget">
						<div class="social-links pt-10">
							<p class="text d-inline-block pr-20"><i class="far fa-link"></i>Social Media Links:</p>
							<?php
							// query for the page
							$your_query = new WP_Query( 'pagename=contact' );
							// "loop" through query (even though it's just one page) 
							while ( $your_query->have_posts() ) : $your_query->the_post();?>
							<ul class="d-inline-block">
								<li>
									<a href="<?php the_field('facebook'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="<?php the_field('twitter'); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
								</li>
								<li>
									<a href="<?php the_field('linkedin'); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
								</li>
								<li>
									<a href="<?php the_field('instagram'); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
								</li>
								<li>
									<a href="<?php the_field('youtube'); ?>" target="_blank"><i class="fab fa-youtube"></i></a>
								</li>
							</ul>
							<?php
								endwhile;
								// reset post data (important!)
								wp_reset_postdata();
							?>
						</div>
					</div>
				</div>
				</div>
				<div class="col-sm-6 col-lg-3">
					<div class="widget">
						<h3 class="widget_title">Our Links</h3>
						<?php wp_nav_menu( array('theme_location' => 'footer1-menu' ) ); ?>
					</div>

				</div>
				<div class="col-sm-6 col-lg-3">
					<div class="widget">
						<h3 class="widget_title">Businesses</h3>
						<?php wp_nav_menu( array('theme_location' => 'footer3-menu' ) ); ?>
					</div>

				</div>
				<div class="col-sm-6 col-lg-3">
				<div class="widget">
					<h3 class="widget_title">Contact Info</h3>
					<?php
						// query for the page
						$your_query = new WP_Query( 'pagename=contact' );
						// "loop" through query (even though it's just one page) 
						while ( $your_query->have_posts() ) : $your_query->the_post();?>
						<div class="vs-contact-widget">

							<?php if( get_field('address') ): ?>
							<p class="text"><i class="far fa-map-marker-alt"></i><?php the_field('address'); ?></p>
							<?php endif; ?>								

							<?php if( get_field('toll_free') ): ?>
							<p class="text"><i class="fal fa-phone-office"></i><a href="tel:<?php the_field('toll_free'); ?>"><?php the_field('toll_free'); ?></a></p>
							<?php endif; ?>

							<?php if( get_field('mobile1') ): ?>
							<p class="text"><i class="fa fa-phone"></i><a href="tel:<?php the_field('mobile1'); ?>"><?php the_field('mobile1'); ?></a></p>
							<?php endif; ?>

							<?php if( get_field('email1') ): ?>
							<p class="text"><i class="fal fa-envelope"></i><a href="mailto:<?php the_field('email1'); ?>"><?php the_field('email1'); ?></a></li>
							<?php endif; ?>

							<?php if( get_field('web') ): ?>
							<p class="text"><i class="fal fa-globe"></i> <?php the_field('web'); ?></li>
							<?php endif; ?>

						</div>
					<?php
						endwhile;
						// reset post data (important!)
						wp_reset_postdata();
					?>
				</div>
				</div>
			</div>
			<div class="row">
				<div class="fotter-bottom-menu">
					<?php wp_nav_menu( array('theme_location' => 'footer2-menu' ) ); ?>
				</div>
			</div>				
		</div>
	</div>
	<div class="footer-copyright">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-lg-6">
					<p class="copyright">Copyright © <span>Foroly India</span>. All Rights Reserved.</p>
				</div>
				<div class="col-sm-12 col-lg-6">
				<p class="footer-develop">Developed by <a href="http://www.nspiretech.com/" title="Nspire Technologies" target="_blank">Nspire Technologies</a></p>
				</div>	
			</div>
		</div>	
	</div>
</footer>	

<a href="#" class="scrollToTop text-white"><i class="far fa-long-arrow-alt-up"></i></a>

<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/vendor/jquery-1.12.4.min.js"></script>
<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/app.min.js"></script>
<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/vscustom-carousel.min.js"></script>
<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/vsmenu.min.js"></script>
<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/ajaxmail.js"></script>
<script src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/js/main.js"></script>

<?php wp_footer(); ?>

</body>
</html>