<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
	
	 <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&amp;family=Roboto:wght@400;500;700&amp;display=swap" rel="stylesheet" />
	
	<!-- Favicon and Touch Icons -->
	<link rel="apple-touch-icon" sizes="57x57" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-57x57.png" />
	<link rel="apple-touch-icon" sizes="60x60" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-60x60.png" />
	<link rel="apple-touch-icon" sizes="72x72" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-72x72.png" />
	<link rel="apple-touch-icon" sizes="76x76" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-76x76.png" />
	<link rel="apple-touch-icon" sizes="114x114" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-114x114.png" />
	<link rel="apple-touch-icon" sizes="120x120" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-120x120.png" />
	<link rel="apple-touch-icon" sizes="144x144" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-144x144.png" />
	<link rel="apple-touch-icon" sizes="152x152" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-152x152.png" />
	<link rel="apple-touch-icon" sizes="180x180" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/apple-icon-180x180.png" />
	<link rel="icon" type="image/png" sizes="192x192" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/android-icon-192x192.png" />
	<link rel="icon" type="image/png" sizes="32x32" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/favicon-32x32.png" />
	<link rel="icon" type="image/png" sizes="96x96" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/favicon-96x96.png" />
	<link rel="icon" type="image/png" sizes="16x16" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/favicon-16x16.png" />
	<meta name="msapplication-TileImage" content="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/ms-icon-144x144.png" />
	
	<!-- Stylesheet Css -->
	<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/css/app.min.css" />
	<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/css/flaticon.min.css" />
	<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/css/fontawesome.min.css" />
	<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/css/style.css" />
	<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/assets/css/spacing.min.css" />
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'twentytwentyone' ); ?></a>
<?php get_template_part( 'template-parts/header/site-header' ); ?>