<?php /* * Template Name: Mission Vision */  ?>
  
<?php get_header(); ?>

<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 25; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li>Company</li>
				<li class="active">
					<?php 
						$char_limit = 25; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->

<!--Page data-->
<section class="page-section">
	<div class="container">
		<?php while ( have_posts() ) : the_post(); ?>
		<div class="page-about">
			<div class="row">
				<div class="col-md-12 col-sm-12">
					<h3 class="title"><?php the_title(); ?></h3>					
				</div>
			</div>
			<div class="row">
				<div class="col-md-6 col-sm-6">
					<div class="page-about-pinnacle green-color">
						<h3 class="text-uppercase"><?php the_field('mission'); ?></h3>
						<div class="icon">
							<img src="<?php the_field('picture'); ?>" alt="Mission" title="Mission">
						</div>							
						<p> <?php the_field('contain'); ?></p>
					</div>
				</div>			

				<div class="col-md-6 col-sm-6">
					<div class="page-about-pinnacle yellow-color">
						<h3 class="text-uppercase"><?php the_field('vision'); ?></h3>
						<div class="icon">
							<img src="<?php the_field('picture_vision'); ?>" alt="Vision" title="Vision">
						</div>							
						<p> <?php the_field('contain_vision'); ?></p>						
					</div>					
				</div>	
			</div>
		</div>	
		<?php
			endwhile;
			// reset post data (important!)
			wp_reset_postdata();
		?>
		
	</div>
</section>
<!--Page data end-->

<?php get_footer(); ?>
