<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();
?>

<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 25; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li class="active">
					<?php 
						$char_limit = 25; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->

<!--Page data-->
	<section class="page-section">
		<div class="container">
			<div class="row">
				<div class="col-md-9 col-sm-12">
				<?php while ( have_posts() ) : the_post(); ?>
					<h3><?php the_title(); ?></h3>
					<div class="page-about">
						<div class="feature-pic" style="max-width: 500px; margin: 0 0 10px 0;">
							<?php the_post_thumbnail(); ?>
						</div>
						<?php the_content(); ?> 
					</div>
					<?php
						endwhile;
						// reset post data (important!)
						wp_reset_postdata();
					?>
				</div>
				<div class="col-md-3 col-sm-12 hidden-xs">
				<div class="side-bar-widget">
					<?php include('sidebar-about.php');?>
				</div>	
			</div>
			</div>
		</div>
	</section>
<!--Page data end-->

<?php get_footer(); ?>