<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();
?>
<script type="text/javascript">
function genericSocialShare(url){
    window.open(url,'sharer','toolbar=0,status=0,width=648,height=395');
    return true;
}
</script>
<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 25; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>blog">Blogs</a></li>
				<li class="active">
					<?php 
						$char_limit = 25; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->

<!--Page data-->
<?php while ( have_posts() ) : the_post(); ?>
	<section class="page-section">
		<div class="container">
			<div class="page-about single-blog">
				<div class="row">
					<div class="col-md-9 col-sm-12">
						<h3 class="title"><?php the_title(); ?></h3>
						<div class="page-about-intro">
							<div><?php the_post_thumbnail(); ?></div>
							
							<div class="blog-meta">
								<span><i class="far fa-user"></i> <?php global $current_user; wp_get_current_user(); ?>
																<?php if ( is_user_logged_in() ) { 
																   echo 'Post by: ' . $current_user->display_name . "\n"; } 
																else { wp_loginout(); } ?>
																</span>
								<span><i class="fal fa-calendar-alt"></i> <?php echo get_the_date( 'Y-m-d' ); ?></span>
							</div>
							 
							<?php the_content(); ?>

						</div>
						
						<div class="share-links pt-lg-10">
							<div class="row align-items-lg-center">
								<div class="col-sm-7 col-md-7">
									<h3 class="text-20 mb-10 mb-md-15">Related Tags:</h3>
									<!--<div class="tagcloud"><a href="#">Repair</a></div>-->
								</div>
								<div class="col-sm-5 col-md-5 pt-3 pt-sm-0 text-left text-sm-right">
									<h3 class="text-20 mb-10 mb-md-15">Share:</h3>
									<ul class="social-links mb-0">		
										<li><a href="javascript:void(0);" onclick="javascript:genericSocialShare('https://wa.me/?text=<?php the_title(); ?> %20 <?php echo get_permalink() ;?>')" title="Whatsapp"><i class="fab fa-whatsapp"></i></a></li>
										<li><a href="javascript:void(0);" onclick="javascript:genericSocialShare('http://www.facebook.com/sharer.php?u=<?php echo get_permalink() ;?>')" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
										<li><a href="javascript:void(0);" onclick="javascript:genericSocialShare('http://twitter.com/share?text=<?php the_title(); ?>&url=<?php echo get_permalink() ;?>')" title="Twitter"><i class="fab fa-twitter"></i></a></li>
										<li><a href="javascript:void(0);" onclick="javascript:genericSocialShare('https://www.instagram.com/?url=<?php echo get_permalink() ;?>')" title="Instagram"><i class="fab fa-instagram"></i></a></li> 
										<li><a href="javascript:void(0);" onclick="javascript:genericSocialShare('http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_permalink() ;?>')" title="LinkedIn"><i class="fab fa-linkedin"></i></a></li>
									</ul>
								</div>
							</div>
						</div>
						
						<div class="post-pagination-wrap post-pagination-layout1">
							<?php 
							the_post_navigation( array(

									'prev_text' => ' 
									<span class="nav-title">%title</span>
									
									<span class="meta-nav">' . __( '« Previous Post', 'twentytwentyone' ) . '</span>',

									'next_text' => '
									<span class="nav-title">%title</span>
									
									<span class="meta-nav">' . __( 'Next Topic »', 'twentytwentyone' ) . '</span>',		 

								) );
							?> 
							
						</div>
						
					</div>
					<div class="col-md-3 col-sm-12">
						<div class="widget widget_categories">
							<h4 class="widget-title">Company</h4>
							<?php wp_nav_menu( array('theme_location' => 'footer1-menu' ) ); ?>
						</div>

						<div class="widget widget_categories">
							<h4 class="widget-title">About Us</h4>
							<?php wp_nav_menu( array('theme_location' => 'footer2-menu' ) ); ?>
						</div>
						 <!--sidebar end -->
					</div>
				</div>
			</div>
			     		
		</div>	
	</section> 
<!--Page data end-->	

 <?php
	endwhile;
	// reset post data (important!)
	wp_reset_postdata();
?>

<?php get_footer(); ?>