<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();
?>
<script type="text/javascript">
function genericSocialShare(url){
    window.open(url,'sharer','toolbar=0,status=0,width=648,height=395');
    return true;
}
</script>
<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 40; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li>Products</li>
				<li class="active">
					<?php 
						$char_limit = 40; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->

<!--Page data-->
<?php while ( have_posts() ) : the_post(); ?>
	<section class="page-section">
		<div class="container">
			<div class="page-about single-blog">
				<div class="row">
					<div class="col-md-9 col-sm-12">
						<div class="sec-title">
							<h3><?php the_title(); ?></h3>
							<p><?php the_field('overview'); ?></p>
						</div>
						
						 <div class="blog-section column-view">
							<article class="column-box blog-box">
								<div class="inner-box">
									<figure class="image">
										<a href="enquiry.html"><?php the_post_thumbnail(); ?></a>
									</figure>
									<div class="post-content clearfix">
										<!--<h3 class="post-title"><a href="enquiry.html"> MHEC (Methyl Hydroxyethyl Cellulose)</a></h3>-->
										<div class="text">
											<?php the_content(); ?>
											
											 
										</div>
										<div class="text-right link"><a href="<?php echo site_url(); ?>/contact" class="theme-btn dark-btn"><i class="fal fa-envelope"></i> Enquiry</a></div>
									</div>
								</div>
							</article>
						</div>
						
						
					</div>
					<div class="col-md-3 col-sm-12">
						<div class="widget widget_categories">
							<h4 class="widget-title">Products</h4>
							<?php wp_nav_menu( array('theme_location' => 'footer2-menu' ) ); ?>
						</div>
						 <!--sidebar end -->
					</div>
				</div>
			</div>
			     		
		</div>	
	</section> 
<!--Page data end-->	

 <?php
	endwhile;
	// reset post data (important!)
	wp_reset_postdata();
?>

<?php get_footer(); ?>