<?php
/**
 * Displays the site header.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

$wrapper_classes  = 'site-header';
$wrapper_classes .= has_custom_logo() ? ' has-logo' : '';
$wrapper_classes .= ( true === get_theme_mod( 'display_title_and_tagline', true ) ) ? ' has-title-and-tagline' : '';
$wrapper_classes .= has_nav_menu( 'primary' ) ? ' has-menu' : '';
?>
<style>.sub-menu-toggle {
  display: none;
}</style>

<div class="vs-menu-wrapper">
	<div class="vs-menu-area">
		<button class="vs-menu-toggle"><i class="fal fa-times"></i></button>
		<div class="mobile-custom-menu">
			<ul>
				<li><a href="<?php echo site_url(); ?>" title="Home">Home</a></li>
				<li>
					<a href="#">Company</a>				
					<?php wp_nav_menu( array('theme_location' => 'footer4-menu' ) ); ?>				
				</li>
				<li><a href="#">Businesses</a></li>				
				<li>
					<a href="#">Sectors</a>											
					<?php wp_nav_menu( array('theme_location' => 'footer5-menu' ) ); ?>
				</li>
				<li>
					<a href="#">Companies</a>
					<?php wp_nav_menu( array('theme_location' => 'footer3-menu' ) ); ?>
				</li>
				<li>
					<a href="#">Media</a>
					<?php wp_nav_menu( array('theme_location' => 'footer6-menu' ) ); ?>
				</li>
					
				<li><a href="<?php echo site_url(); ?>/blogs" title="Blogs">Blogs</a></li> 
				 
			</ul>	
		</div>
	</div>
</div>

<div class="sticky-header-wrap sticky-header py-1 py-sm-2 py-lg-1">
	<div class="container position-relative">
		<div class="row align-items-center">
			<div class="col-5 col-md-3">
				<div class="logo">
					<a href="<?php echo site_url(); ?>"><img src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/Foroly.png" alt="Foroly India" title="Foroly India" /></a>
				</div>
			</div>
			<div class="col-7 col-md-9 text-right position-static">
				<nav class="main-menu menu-style1 d-none d-lg-block">
					<ul>
						<li class="active"><a href="<?php echo site_url(); ?>" title="Home">Home</a></li>
						<li class="menu-item-has-children">
							<a href="#">Company</a>
							<ul class="submenu">
								<?php wp_nav_menu( array('theme_location' => 'footer4-menu' ) ); ?>
							</ul>
						</li>

						<li class="mega-menu-wrap menu-item-has-children">
							<a href="#">Businesses</a>
							<ul class="mega-menu">
								<li>
									<a href="#">Sectors</a>											
									<?php wp_nav_menu( array('theme_location' => 'footer5-menu' ) ); ?>
								</li>
								<li>
									<a href="#">Companies</a>
									<?php wp_nav_menu( array('theme_location' => 'footer3-menu' ) ); ?>
								</li>
							</ul>
						</li>
						<li class="menu-item-has-children">
							<a href="#">Media</a>
							<ul class="submenu">
								<?php wp_nav_menu( array('theme_location' => 'footer6-menu' ) ); ?>
							</ul>
						</li>
						<li><a href="<?php echo site_url(); ?>/blogs" title="Blogs">Blogs</a></li> 
					</ul>
				</nav>
				<?php /*?><?php get_template_part( 'template-parts/header/site-nav1' ); ?><?php */?>
			</div>
		</div>
	</div>
</div>
	
<header class="vs-header-wrapper header-layout1 header-overlay" data-overlay="white" >
	<div class="header-top-wrap">
		<div class="container">
			<div class="row align-items-center">
				<?php
				// query for the page
				$your_query = new WP_Query( 'pagename=contact' );
				// "loop" through query (even though it's just one page) 
				while ( $your_query->have_posts() ) : $your_query->the_post();?>

				<div class="col-12 col-md-6 col-xl-6">
					<div class="header-top-right text-left text-md-right">
						<div class="social-links text-white">
							
								<ul>
									<li>
										<a href="<?php the_field('facebook'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
									</li>
									<li>
										<a href="<?php the_field('twitter'); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
									</li>
									<li>
										<a href="<?php the_field('linkedin'); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
									</li>
									<li>
										<a href="<?php the_field('instagram'); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
									</li>
									<li>
										<a href="<?php the_field('youtube'); ?>" target="_blank"><i class="fab fa-youtube"></i></a>
									</li>
								</ul>
								
						</div>
					</div>
				</div>
				<div class="col-12 col-md-4 col-xl-4">
					<div class="header-top-right top-cont-email float-right">
						<p class="text text-white">
							<?php if( get_field('toll_free') ): ?>
							<i class="fal fa-phone-office"></i><a href="tel:<?php the_field('toll_free'); ?>"><?php the_field('toll_free'); ?></a>
							<?php endif; ?>
							<?php if( get_field('email1') ): ?>
							<i class="fal fa-envelope"></i><a href="mailto:<?php the_field('email1'); ?>"><?php the_field('email1'); ?></a>
							<?php endif; ?>
						</p>
						
					</div>
				</div>
				<div class="col-sm-12 col-xl-2">
					<ul class="top-links">

						<li><a href="<?php echo site_url(); ?>/?page_id=20" title="Contact">Contact</a></li>
					</ul>
				</div>
			</div>
			<?php
				endwhile;
				// reset post data (important!)
				wp_reset_postdata();
			?>
			
		</div>
	</div>
	<div class="header-menu-wrap">
		<div class="container position-relative">
			<div class="row">
				<div class="col-lg-3 col-lg-3 col-xl-3">
					<div class="header-menu-left">
						<div class="header-logo">
							<a href="<?php echo site_url(); ?>"><img src="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/Foroly.png" alt="Foroly India" title="Foroly India" /></a>
						</div>
					</div>
				</div>
				<div class="col-md-12 col-lg-9 col-xl-9 position-static">
					<nav class="main-menu menu-style1 text-center mobile-menu-active">
							<ul>
								<li class="active"><a href="<?php echo site_url(); ?>" title="Home">Home</a></li>
								<li class="menu-item-has-children">
									<a href="#">Company</a>
									<ul class="submenu">
										<?php wp_nav_menu( array('theme_location' => 'footer4-menu' ) ); ?>
									</ul>
								</li>
								
								<li class="mega-menu-wrap menu-item-has-children">
                                    <a href="#">Businesses</a>
                                    <ul class="mega-menu">
										<li>
											<a href="#">Sectors</a>											
											<?php wp_nav_menu( array('theme_location' => 'footer5-menu' ) ); ?>
										</li>
										<li>
											<a href="#">Companies</a>
											<?php wp_nav_menu( array('theme_location' => 'footer3-menu' ) ); ?>
										</li>
									</ul>
                                </li>
								<li class="menu-item-has-children">
									<a href="#">Media</a>
									<ul class="submenu">
										<?php wp_nav_menu( array('theme_location' => 'footer6-menu' ) ); ?>
									</ul>
								</li>
								<li><a href="<?php echo site_url(); ?>/?page_id=73" title="Blogs">Blogs</a></li> 
							</ul>
						</nav>
					<button class="vs-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
					<?php /*?><?php get_template_part( 'template-parts/header/site-nav' ); ?><?php */?>
					
				</div>

			</div>
		</div>
	</div>
</header>

