 <?php /* * Template Name: Testimonial */  ?>
  
<?php get_header(); ?>

<!--Page header-->
<div class="breadcumb-wrapper breadcumb-layout1 background-image" data-vs-img="<?php echo site_url(); ?>/wp-content/themes/twentytwentyone-child/images/breadcumb.jpg" data-overlay="primary3" data-opacity="1">
	<div class="container">
		<div class="breadcumb-content">
			<h1 class="breadcumb-title title1 text-white mb-0">
				<?php 
					$char_limit = 25; //character limit
					$content = $post->post_title; //contents saved in a variable
					echo substr(strip_tags($content), 0, $char_limit);
				?>
			</h1>
			<ul>
				<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
				<li class="active">
					<?php 
						$char_limit = 25; //character limit
						$content = $post->post_title; //contents saved in a variable
						echo substr(strip_tags($content), 0, $char_limit);
					?>
				</li>
			</ul>
		</div>
	</div>
</div>
<!--Page header end-->	

<!--Page data-->
	<section class="page-section testi-page">
		<div class="container">
			<div class="row">
				<div class="col-md-12 col-sm-12">
					<!--Page -->
					<div class="sec-title">
						<h3>Testimonials</h3>
					</div>
					<section class="vs-testimonial-wrapper vs-testimonial-layout2 pt-10">
						
						
						<div class="row">
							
							<?php
							$paged = get_query_var('paged') ? get_query_var('paged') : 1;
							$args = array(
								'post_type' => 'testimonials',
								'post_status' => 'publish',
								//category_name' => 'downloads',
								'posts_per_page' => 12,
								'paged' => $paged,
							);
							$arr_posts = new WP_Query( $args );
							if ($arr_posts->have_posts()) :
								while ($arr_posts->have_posts()) : $arr_posts->the_post()
							?>
							
							<div class="col-xl-6">
								<div class="vs-testimonial bg-white">
									<div class="testi-incontain">
										<?php 
											$char_limit = 60; //character limit
											$content = $post->post_content; //contents saved in a variable
											echo substr(strip_tags($content), 0, $char_limit);
										?>
									</div>

									<div class="testo-author">
										<div class="img"><?php the_post_thumbnail(); ?></div>
										<div class="author-info">
											<h3 class="name heading5 mb-0"><?php the_title(); ?></h3>
											<span class="degi text-sm text-title"><?php the_field('designation'); ?></span>
										</div>
									</div>
								</div>
							</div>
							
							<?php endwhile ?>

							<div class="col-lg-12 text-center">
								<div class="pagination-wrapper pagination ">
									<?php
										$total_pages = $arr_posts->max_num_pages;
										if ($total_pages > 1){

											$current_page = max(1, get_query_var('paged'));

											echo paginate_links(array(
												'base' => get_pagenum_link(1) . '%_%',
												'format' => '/page/%#%',
												'current' => $current_page,
												'total' => $total_pages,
												'prev_text'    => __('« prev'),
												'next_text'    => __('next »'),
												'add_args'  => array()
											));
										}
										?>
								</div>
							</div>	
							<?php else :?>
							<h3><?php _e('404 Error: Not Found', ''); ?></h3>
							<?php endif; wp_reset_postdata();?>
							
						</div>
					</section>	
					<!--Page end-->
				</div>

			</div>
		</div>
	</section>
<!--Page data end-->

<?php get_footer();